<?php

	//  AME Autmoatic Media Embedder 2.0.0
	//	Copyright 2008 All rights reserved by sweetsquared.com
	//	This code may not be used in whole or part without explicit written
	//	permission from Samuel Sweet at sweetsquared.com.
	//  You may not distribute this or any of the associated files in whole or significant part
	//	without explicit written permission from Samuel Sweet at sweetsquared.com

	error_reporting(E_ALL & ~E_NOTICE);

	define('NO_REGISTER_GLOBALS', 1);

	$phrasegroups 		= array('automediaembed_admin');
	$specialtemplates 	= array('AME_settings');

	require_once('./global.php');

	if (!$_REQUEST['do'])
	{
	    $action	= "display";
	    $_REQUEST['do'] = "display";
	}
	else
	{
	    $action	= $_REQUEST['do'];
	}	
	
	/**
	 * Simple redirection of vB
	 *
	 * @param string $do
	 * @param string $stopmessage
	 * @param string $var
	 */
	function redirect($do, $stopmessage, $var = '')
	{
		define('CP_REDIRECT', "automediaembed_admin.php?do=$do");
		print_stop_message($stopmessage, $var);
	}

	if ($_REQUEST['do'] != "doexport")
	{
		print_cp_header($vbphrase['automediaembed_cp_title']);

		?>
		
		<script type="text/javascript">
		
		    function grab_left(str, n)
		    {
		            if (n <= 0)
		            {
		                return "";
		            }
		            else if (n > String(str).length)
		            {
		                return str;
		            }
		            else
		            {
		                return String(str).substring(0,n);
		            }
		    }
		
			
		    function tick_all(formobj,type,value)
		    {
		            for (var i =0; i < formobj.elements.length; i++)
		            {
		                   var elm = formobj.elements[i];
		                   if (elm.type == "checkbox")
		                   {
		                         if (grab_left(elm.name,String(type).length) == type)
		                         {
		                             elm.checked = value;
		                         }
		                   }
		            }
		    }
		</script>
		<?		
		
		if (!$vbulletin->options['automediaembed_resolve'])
		{
			print_form_header('automediaembed_admin', '', false, true, 'warningform');
			print_table_header($vbphrase['automediaembed_warning']);
			print_description_row($vbphrase['automediaembed_extraction_off']);
			print_table_footer();
		}
	}

	/**
	 * Display settings
	 */
	if ($action == "settings")
	{

		$settings = array(
			'xusergroups'	=> explode(",", $vbulletin->options['automediaembed_usergroups']),
			'xforums'		=> explode(",", $vbulletin->options['automediaembed_forumids']),
			'open'			=> $vbulletin->options['automediaembed_open'],
			'close'			=> $vbulletin->options['automediaembed_close'],
		);
		$results = $db->query_read_slave("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid ASC ");

		print_form_header('automediaembed_admin', 'savesettings');
		print_table_header($vbphrase['automediaembed_settings']);
		print_yes_no_row($vbphrase['automediaembed_disable_new'], 'disablenew', $vbulletin->options['automediaembed_disable']);
		print_yes_no_row($vbphrase['automediaembed_doforums'], 'doforums', $vbulletin->options['automediaembed_doforums']);
		print_yes_no_row($vbphrase['automediaembed_doblogs'], 'doblogs', $vbulletin->options['automediaembed_doblogs']);
		print_yes_no_row($vbphrase['automediaembed_dogroups'], 'dogroups', $vbulletin->options['automediaembed_dogroups']);
		print_yes_no_row($vbphrase['automediaembed_dovms'], 'dovms', $vbulletin->options['automediaembed_dovms']);
		print_yes_no_row($vbphrase['automediaembed_resolve'], 'resolve', $vbulletin->options['automediaembed_resolve']);
		print_input_row($vbphrase['automediaembed_limit'], 'limit', $vbulletin->options['automediaembed_limit']);
		print_table_header($vbphrase['automediaembed_container_html_title']);
		print_textarea_row($vbphrase['automediaembed_container_html_open'], 'open', $settings['open']);
		print_textarea_row($vbphrase['automediaembed_container_html_close'], 'close', $settings['close']);
		print_table_header($vbphrase['automediaembed_exempt_forums_title']);
		print_forum_chooser($vbphrase['automediaembed_exempt_forums'], 'xforums[]', $settings['xforums'], null , false, true);

        if ($results)
        {
			print_table_header($vbphrase['automediaembed_exempt_usergroups_title']);

			while($result = $db->fetch_array($results))
			{
				print_checkbox_row("$result[title]", "xusergroups[$result[usergroupid]]", (in_array($result['usergroupid'], $settings['xusergroups'])));
			}
        }

        print_submit_row();

	}


	/**
	 * Save Settings
	 */
	if ($action == "savesettings")
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'xforums'		=> TYPE_ARRAY_UINT,
			'xusergroups'	=> TYPE_ARRAY_UINT,
			'disablenew'	=> TYPE_BOOL,
			'doforums'		=> TYPE_BOOL,
			'doblogs'		=> TYPE_BOOL,
			'dogroups'		=> TYPE_BOOL,
			'dovms'			=> TYPE_BOOL,
			'open'			=> TYPE_STR,
			'close'			=> TYPE_STR,
			'resolve'		=> TYPE_BOOL,
			'limit'			=> TYPE_UINT,
		));

		if (is_array($vbulletin->GPC['xforums']))
		{
			foreach($vbulletin->GPC['xforums'] as $key => $value)
			{
				$forum_hint .= ($forum_hint ? "," : "") . "$value";
			}
		}

	    if (is_array($vbulletin->GPC['xusergroups']))
	    {
	        foreach($vbulletin->GPC['xusergroups'] as $key => $value)
	        {
				$ug_hint .= ($ug_hint ? "," : "") . "$key";
	        }
	    }

	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='$forum_hint' WHERE varname='automediaembed_forumids' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='$ug_hint' WHERE varname='automediaembed_usergroups' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='" . $vbulletin->GPC['disablenew'] . "' WHERE varname='automediaembed_disable' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='" . $db->escape_string($vbulletin->GPC['open']) . "' WHERE varname='automediaembed_open' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='" . $db->escape_string($vbulletin->GPC['close']) . "' WHERE varname='automediaembed_close' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='" . $db->escape_string($vbulletin->GPC['limit']) . "' WHERE varname='automediaembed_limit' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='" . $db->escape_string($vbulletin->GPC['resolve']) . "' WHERE varname='automediaembed_resolve' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='" . $db->escape_string($vbulletin->GPC['doforums']) . "' WHERE varname='automediaembed_doforums' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='" . $db->escape_string($vbulletin->GPC['doblogs']) . "' WHERE varname='automediaembed_doblogs' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='" . $db->escape_string($vbulletin->GPC['dogroups']) . "' WHERE varname='automediaembed_dogroups' AND grouptitle='automediaembed_group'");
	    $db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value='" . $db->escape_string($vbulletin->GPC['dovms']) . "' WHERE varname='automediaembed_dovms' AND grouptitle='automediaembed_group'");

	    build_options();

		redirect('settings', 'automediaembed_saved_settings');
	}

	/**
	 * Dsiplay Items
	 */
	if ($action == "display")
	{
		$results = $db->query_read_slave("SELECT id, title, displayorder, description, extraction, status, container from " . TABLE_PREFIX . "automediaembed ORDER BY displayorder, title ASC");

		print_form_header('automediaembed_admin', 'savedisplay');

		if ($db->num_rows($results))
		{
			print_table_header($vbphrase['automediaembed_media_definitions'], 6);
			print_cells_row(array($vbphrase['title'], $vbphrase['automediaembed_display_order'], "<label for=\"status_toggle\">$vbphrase[automediaembed_active]</label> <input type=\"checkbox\" id=\"status_toggle\" onclick=\"tick_all(this.form, 'status', this.checked)\" />", "<label for=\"container_toggle\">$vbphrase[automediaembed_contain]</label> <input type=\"checkbox\" id=\"container_toggle\" onclick=\"tick_all(this.form, 'container', this.checked)\" />", "<label for=\"extract_toggle\">$vbphrase[automediaembed_extract]</label> <input type=\"checkbox\" id=\"extract_toggle\" onclick=\"tick_all(this.form, 'extract', this.checked)\" />", "<label for=\"delete_toggle\">$vbphrase[delete]</label> <input type=\"checkbox\" id=\"delete_toggle\" onclick=\"tick_all(this.form, 'deleted', this.checked)\" />"), true);
			while($result = $db->fetch_array($results))
			{
				construct_hidden_code("oldorder[$result[id]]", $result['displayorder']);
				construct_hidden_code("oldextract[$result[id]]", $result['extraction']);
				construct_hidden_code("oldstatus[$result[id]]", $result['status']);
				construct_hidden_code("oldcontainer[$result[id]]", $result['container']);
				print_cells_row(array(
					"<a href=\"automediaembed_admin.php?do=edit&id=$result[id]\">$result[title]</a><dfn>$result[description]</dfn>",
					"<input type=\"input\" name=\"order[$result[id]]\" size=\"10\" value=\"$result[displayorder]\" />",
					"<input type=\"checkbox\" name=\"status[$result[id]]\" value=\"1\" " . ($result['status'] ? "checked=\"checked\"" : "") . " />",
					"<input type=\"checkbox\" name=\"container[$result[id]]\" value=\"1\" " . ($result['container'] ? "checked=\"checked\"" : "") . " />",
					"<input type=\"checkbox\" name=\"extract[$result[id]]\" value=\"1\" " . ($result['extraction'] ? "checked=\"checked\"" : "") . " />",
					//"[<a href=\"automediaembed_admin.php?do=edit&id=$result[id]\">$vbphrase[edit]</a>] [<a href=\"automediaembed_admin.php?do=delete&id=$result[id]\">$vbphrase[delete]</a>]"
					"<input type=\"checkbox\" name=\"deleted[$result[id]]\" id=\"deleted_$result[id]\" value=\"1\" />"
				));
			}

			print_table_footer(6, construct_button_code($vbphrase['automediaembed_add_new'], "automediaembed_admin.php?do=edit") . " <input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"$vbphrase[save]\" accesskey=\"s\" />");
		}
		else
		{
			print_table_header($vbphrase['automediaembed_media_definitions'], 2);
			print_description_row($vbphrase['automediaembed_no_definitions']);
			print_table_footer(2, construct_button_code($vbphrase['automediaembed_add_new'], "automediaembed_admin.php?do=edit"));
		}

	}

	/**
	 * Save Disaply
	 */
	if ($action == "savedisplay")
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'order' 		=> TYPE_ARRAY_UINT,
			'oldorder' 		=> TYPE_ARRAY_UINT,
			'oldstatus'		=> TYPE_ARRAY_BOOL,
			'status'		=> TYPE_ARRAY_BOOL,
			'oldcontainer'	=> TYPE_ARRAY_BOOL,
			'container'		=> TYPE_ARRAY_BOOL,
			'oldextract'	=> TYPE_ARRAY_BOOL,
			'extract'		=> TYPE_ARRAY_BOOL,
			'deleted'		=> TYPE_ARRAY_BOOL,
			'confirmed'		=> TYPE_BOOL,
			));

		$order 		= $vbulletin->GPC['order'];
		$oldorder 	= $vbulletin->GPC['oldorder'];
		$oldstatus 	= $vbulletin->GPC['oldstatus'];
		$status 	= $vbulletin->GPC['status'];
		$oldcontainer = $vbulletin->GPC['oldcontainer'];
		$container 	= $vbulletin->GPC['container'];
		$oldextract = $vbulletin->GPC['oldextract'];
		$extract 	= $vbulletin->GPC['extract'];
		$deleted 	= $vbulletin->GPC['deleted'];
		$confirmed 	= $vbulletin->GPC['confirmed'];

		if (sizeof($deleted) AND !$confirmed)
		{
			foreach($deleted as $key=>$value)
			{
				$ids .= ($ids ? "," : "") . $key;
			}
			
			if ($ids)
			{
				$results = $db->query_read_slave("SELECT title FROM " . TABLE_PREFIX . "automediaembed where id in ($ids)");
				
				while($result = $db->fetch_array($results))
				{
					$todelete .= ($todelete ? ", " : "") . $result['title'];
				}
			}			
			
			print_form_header('automediaembed_admin', 'savedisplay');
			foreach($oldorder as $key => $old)
			{
				construct_hidden_code("order[$key]", $order["$key"]);
				construct_hidden_code("oldorder[$key]", $oldorder["$key"]);
				construct_hidden_code("oldstatus[$key]", $oldstatus["$key"]);
				construct_hidden_code("status[$key]", $status["$key"]);
				construct_hidden_code("oldcontainer[$key]", $oldcontainer["$key"]);
				construct_hidden_code("container[$key]", $container["$key"]);
				construct_hidden_code("oldextract[$key]", $oldextract["$key"]);
				construct_hidden_code("extract[$key]", $extract["$key"]);
				construct_hidden_code("deleted[$key]", $deleted["$key"]);
			}
			construct_hidden_code("confirmed", "true");
			
			print_table_header($vbphrase['automediaembed_confirm_delete']);
			print_description_row(construct_phrase($vbphrase['automediaembed_confirm_delete_question'], $todelete));
			print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);			
		}
		else 
		{
		
			if (!empty($oldorder))
			{
				foreach($oldorder as $key =>$value)
				{
					if ($deleted["$key"])
					{
						$delete .= ($delete ? "," : "") . $key;
						
					}
					else 
					{
						if ($value != $order["$key"])
						{
							$update["$key"]['displayorder'] = $order["$key"];
						}
						if ($oldstatus["$key"] != $status["$key"])
						{
							$update["$key"]['status'] = $status["$key"];
						}
						if ($oldcontainer["$key"] != $container["$key"])
						{
							$update["$key"]['container'] = $container["$key"];
						}
						if ($oldextract["$key"] != $extract["$key"])
						{
							$update["$key"]['extraction'] = $extract["$key"];
						}
					}
	
				}
			}
			
			if ($delete)
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "automediaembed WHERE id in ($delete)");
			}
	
			if (sizeof($update))
			{
	
	
				foreach($update as $id => $columns)
				{
					$columninfo = "";
	
					foreach ($columns as $column => $value)
					{
						$columninfo .= ($columninfo ? ", " : " SET ") . " $column='$value'";
					}
	
					$db->query_write("UPDATE " . TABLE_PREFIX . "automediaembed $columninfo WHERE id=$id");
				}
	
			}
	
			redirect("display", "automediaembed_saved_display_order");
	
		}
	}

	/**
	 * Edit Item
	 */
	if ($action == "edit")
	{
		$id = $vbulletin->input->clean_gpc('r', 'id', TYPE_UINT);

		print_form_header('automediaembed_admin', 'save');

		if ($id)
		{
			$result = $db->query_first_slave("SELECT * FROM " . TABLE_PREFIX . "automediaembed WHERE id=$id");
			construct_hidden_code("id", $id);
			print_table_header($result['title']);
		}
		else
		{
			print_table_header($vbphrase['automediaembed_new_definition']);
		}

		print_input_row($vbphrase['title'], "title", $result['title']);
		print_input_row($vbphrase['description'], "description", $result['description'], true, 35, 255);
		print_input_row($vbphrase['automediaembed_display_order'], "displayorder", $result['displayorder']);
		print_yes_no_row($vbphrase['automediaembed_active_desc'], 'status', $result['status']);
		print_yes_no_row($vbphrase['automediaembed_contain_desc'], 'container', $result['container']);
		print_table_header($vbphrase['automediaembed_code']);
		print_textarea_row($vbphrase['automediaembed_search'], "findcode", $result['findcode']);
		print_textarea_row($vbphrase['automediaembed_replace'], "replacecode", $result['replacecode']);
		print_table_header($vbphrase['automediaembed_extraction_info']);
		print_yes_no_row($vbphrase['automediaembed_extraction'], "extraction", $result['extraction']);
		print_textarea_row($vbphrase['automediaembed_embedregexp'], "embedregexp", $result['embedregexp']);

		print_submit_row();
	}

	/**
	 * Save Item
	 */
	if ($action == "save")
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'id'			=> TYPE_UINT,
			'title'			=> TYPE_STR,
			'description'	=> TYPE_STR,
			'displayorder'	=> TYPE_UINT,
			'findcode'		=> TYPE_STR,
			'replacecode'	=> TYPE_STR,
			'status'		=> TYPE_BOOL,
			'container'		=> TYPE_BOOL,
			'embedregexp'	=> TYPE_STR,
			'extraction'	=> TYPE_BOOL,
		));

		$id 			= $vbulletin->GPC['id'];
		$title 			= $vbulletin->GPC['title'];
		$description 	= $vbulletin->GPC['description'];
		$displayorder 	= $vbulletin->GPC['displayorder'];
		$findcode 		= $vbulletin->GPC['findcode'];
		$replacecode	= $vbulletin->GPC['replacecode'];
		$status			= $vbulletin->GPC['status'];
		$container		= $vbulletin->GPC['container'];
		$embedregexp	= $vbulletin->GPC['embedregexp'];
		$extraction		= $vbulletin->GPC['extraction'];

		if ($id)
		{
			$sql = "UPDATE " . TABLE_PREFIX . "automediaembed SET
				title='" . $db->escape_string($title) . "',
				description = '" . $db->escape_string($description) . "',
				displayorder = '$displayorder',
				findcode = '" . $db->escape_string($findcode) . "',
				replacecode = '" . $db->escape_string($replacecode) . "',
				status ='$status', container='$container',
				embedregexp = '" . $db->escape_string($embedregexp) . "',
				extraction = '" . intval($extraction) . "'
				WHERE id = $id";
		}
		else
		{
			$sql = "INSERT INTO " . TABLE_PREFIX . "automediaembed (title, description, displayorder, findcode, replacecode, status, container, embedregexp, extraction) VALUES (
				'" . $db->escape_string($title) . "',
				'" . $db->escape_string($description) . "',
				'$displayorder',
				'" . $db->escape_string($findcode) . "',
				'" . $db->escape_string($replacecode) . "', '$status', '$container', '" . $db->escape_string($embedregexp) . "', '" . intval($extraction) . "')";
		}

		if ($sql)
		{
			$db->query_write($sql);
		}

		redirect("display", "automediaembed_saved_x", $title);
	}


	/**
	 * Delete Item
	 */
	if ($action == 'delete')
	{

		$id = $vbulletin->input->clean_gpc('r', 'id' , TYPE_UINT);

		$sql = "SELECT title FROM " . TABLE_PREFIX . "automediaembed  WHERE id=$id";
		$result = $db->query_first_slave($sql);

		print_form_header('automediaembed_admin', 'kill');
		construct_hidden_code('id', $id);
		print_table_header($vbphrase['automediaembed_confirm_delete']);
		print_description_row(construct_phrase($vbphrase['automediaembed_confirm_delete_question'], $result['title']));
		print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
	}


	/**
	 * Kill Item
	 */
	if ($action == 'kill')
	{

		$id = $vbulletin->input->clean_gpc('r', 'id', TYPE_UINT);
		if ($id)
		{
			$result = $db->query_first_slave("SELECT title FROM " . TABLE_PREFIX . "automediaembed WHERE id = $id");
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "automediaembed WHERE id=$id");
		}

		redirect('display', 'automediaembed_deleted_x', $result['title']);
	}

	/**
	 * Tools Menu
	 */
	if ($action == 'tools')
	{
		print_form_header();
		print_table_header($vbphrase['automediaembed_tools']);
		print_description_row("<a href=\"automediaembed_admin.php?do=rebuildposts\">$vbphrase[automediaembed_rebuild_title]</a><dfn>$vbphrase[automediaembed_rebuild_desc]</dfn>");
		print_description_row("<a href=\"automediaembed_admin.php?do=rebuildblogs\">$vbphrase[automediaembed_rebuild_blogs_title]</a><dfn>$vbphrase[automediaembed_rebuild_blogs_desc]</dfn>");
		print_description_row("<a href=\"automediaembed_admin.php?do=rebuildgroups\">$vbphrase[automediaembed_rebuild_groups_title]</a><dfn>$vbphrase[automediaembed_rebuild_groups_desc]</dfn>");
		print_description_row("<a href=\"automediaembed_admin.php?do=rebuildvms\">$vbphrase[automediaembed_rebuild_vms_title]</a><dfn>$vbphrase[automediaembed_rebuild_vms_desc]</dfn>");
		print_description_row("<a href=\"automediaembed_admin.php?do=convertposts\">$vbphrase[automediaembed_convert_title]</a><dfn>$vbphrase[automediaembed_convert_desc]</dfn>");
		print_description_row("<a href=\"automediaembed_admin.php?do=addblog\">$vbphrase[automediaembed_addblog_title]</a><dfn>$vbphrase[automediaembed_addblog_desc]</dfn>");
		print_description_row("<a href=\"automediaembed_admin.php?do=addgroups\">$vbphrase[automediaembed_addgroup_title]</a><dfn>$vbphrase[automediaembed_addgroup_desc]</dfn>");
		print_description_row("<a href=\"automediaembed_admin.php?do=addvms\">$vbphrase[automediaembed_addvms_title]</a><dfn>$vbphrase[automediaembed_addvms_desc]</dfn>");
		print_table_footer();
	}
	
	if ($action == 'addblog')
	{
			$db->hide_errors();
			$result = $db->query_first_slave("SELECT max(blogtextid) total FROM " . TABLE_PREFIX . "blog_text");
			$db->show_errors();
			
			if ($db->errno)
			{
				print_stop_message('automediaembed_no_blog');
			}
			
			$db->hide_errors();
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "blog_text ADD ame_flag TINYINT DEFAULT '0' NOT NULL ;");
			$db->show_errors();
			
			redirect('display', 'automediaembed_addedblogs');
	}
	
	if ($action == 'addgroups')
	{
			$db->hide_errors();
			$result = $db->query_first_slave("SELECT max(gmid) total FROM " . TABLE_PREFIX . "groupmessage");
			$db->show_errors();
			
			if ($db->errno)
			{
				print_stop_message('automediaembed_no_group');
			}
			
			$db->hide_errors();
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "groupmessage ADD ame_flag TINYINT DEFAULT '0' NOT NULL ;");
			$db->show_errors();
			
			redirect('display', 'automediaembed_addedgroups');
	}
	
	if ($action == 'addvms')
	{
			$db->hide_errors();
			$result = $db->query_first_slave("SELECT max(vmid) total FROM " . TABLE_PREFIX . "visitormessage");
			$db->show_errors();
			
			if ($db->errno)
			{
				print_stop_message('automediaembed_no_vms');
			}
			
			$db->hide_errors();
			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "visitormessage ADD ame_flag TINYINT DEFAULT '0' NOT NULL ;");
			$db->show_errors();
			
			redirect('display', 'automediaembed_addedvms');
	}

	/**
	 * Rebuild Posts
	 */
	if($action == 'rebuildposts' || $action =='rebuildblogs' || $action == 'rebuildgroups' || $action == 'rebuildvms')
	{
		$inp = $action == 'rebuildposts' ? "" : ($action == 'rebuildblogs' ? 'blogs_' : ($action == 'rebuildvms' ? 'vms_' : 'groups_'));
		$in = $action == 'rebuildposts' ? "" : ($action == 'rebuildblogs' ? 'blogs' : ($action == 'rebuildvms' ? 'vms' : 'groups'));

		if ($in == 'blogs')
		{
			$db->hide_errors();
			$result = $db->query_first_slave("SELECT max(blogtextid) total FROM " . TABLE_PREFIX . "blog_text");
			$db->show_errors();
			
			if ($db->errno)
			{
				print_stop_message('automediaembed_no_blog');
			}
		}
		
		if ($in == 'groups')
		{
			$db->hide_errors();
			$result = $db->query_first_slave("SELECT max(gmid) total FROM " . TABLE_PREFIX . "groupmessage");
			$db->show_errors();
			
			if ($db->errno)
			{
				print_stop_message('automediaembed_no_group');
			}
		}
		
		if ($in == 'vms')
		{
			$db->hide_errors();
			$result = $db->query_first_slave("SELECT max(vmid) total FROM " . TABLE_PREFIX . "visitormessage");
			$db->show_errors();
			
			if ($db->errno)
			{
				print_stop_message('automediaembed_no_vms');
			}
		}
		
	    $lengths = array(
	    	0			=> $vbphrase['automediaembed_length_all'],
	    	604800		=> $vbphrase['automediaembed_length_one_week'],
	    	1209600		=> $vbphrase['automediaembed_length_two_weeks'],
	    	1814400		=> $vbphrase['automediaembed_length_three_weeks'],
	    	2419200		=> $vbphrase['automediaembed_length_one_month'],
	    	7862400		=> $vbphrase['automediaembed_length_three_months'],
	    	15724800	=> $vbphrase['automediaembed_length_six_months'],
	    	31449600	=> $vbphrase['automediaembed_length_one_year'],
	    );

	    $settings = unserialize($vbulletin->AME_settings);

	    if (!$settings)
	    {
	    	$settings = array(
	    		'length'	=> 	2419200,
	    		'perpage'	=>	100,
	    		'seconds'	=>	10,
	    	);
	    }

		print_form_header('automediaembed_admin', 'dorebuildposts', false, true, 'cpform', '90%', '', true, 'get');
		print_table_header($vbphrase['automediaembed_convert_warning_title']);
		print_description_row($vbphrase["automediaembed_convert_warning_" . $inp . "desc"]);
		print_table_break();
		print_table_header($vbphrase['automediaembed_rebuild_' . $inp . 'title']);
		print_yes_no_row($vbphrase['automediaembed_remove_ame'], 'deleteame', false);
		print_yes_no_row($vbphrase['automediaembed_ignore_previous'], 'ignoreprevious', true);
		print_yes_no_row($vbphrase['automediaembed_test_mode'], "test", $settings['test']);
		print_yes_no_row($vbphrase['automediaembed_verbose_mode'], "verbose", $settings['verbose']);
		print_select_row($vbphrase['automediaembed_length'], 'length', $lengths, $settings['length']);
		print_input_row($vbphrase['automediaembed_perpage'], 'perpage', $settings['perpage']);
		print_input_row($vbphrase['automediaembed_seconds_perpage'], 'seconds', $settings['seconds']);
		construct_hidden_code('in', $in);
		print_submit_row();

	}

	/**
	 * Do The Rebuilding of posts
	 */
	if ($action == 'dorebuildposts')
	{
		$vbulletin->input->clean_array_gpc('r', array(
			'ignoreprevious'		=> TYPE_BOOL,
			'length'				=> TYPE_UINT,
			'deleteame'				=> TYPE_BOOL,
			'perpage'				=> TYPE_UINT,
			'seconds'				=> TYPE_UINT,
			'cont'					=> TYPE_UINT,
			'test'					=> TYPE_BOOL,
			'verbose'				=> TYPE_BOOL,
			'start'					=> TYPE_UINT,
			'in'					=> TYPE_STR
		));

		$length 			= $vbulletin->GPC['length'];
		$start				= $vbulletin->GPC['start'];
		$perpage 			= $vbulletin->GPC['perpage'];
		$seconds 			= $vbulletin->GPC['seconds'];
		$ignoreprevious		= $vbulletin->GPC['ignoreprevious'];
		$deleteame			= $vbulletin->GPC['deleteame'];
		$cont				= $vbulletin->GPC['cont'];
		$test				= $vbulletin->GPC['test'];
		$verbose			= $vbulletin->GPC['verbose'];
		$in					= $vbulletin->GPC['in'];

		if ($in == 'blogs')
		{
			$db->hide_errors();
			$result = $db->query_first_slave("SELECT max(blogtextid) total FROM " . TABLE_PREFIX . "blog_text");
			$db->show_errors();
			
			if ($db->errno)
			{
				print_stop_message('automediaembed_no_blog');
			}
		}

		if ($in == 'groups')
		{
			$db->hide_errors();
			$result = $db->query_first_slave("SELECT max(gmid) total FROM " . TABLE_PREFIX . "groupmessage");
			$db->show_errors();
			
			if ($db->errno)
			{
				print_stop_message('automediaembed_no_group');
			}
		}
		
		if ($in == 'vms')
		{
			$db->hide_errors();
			$result = $db->query_first_slave("SELECT max(vmid) total FROM " . TABLE_PREFIX . "visitormessage");
			$db->show_errors();
			
			if ($db->errno)
			{
				print_stop_message('automediaembed_no_vms');
			}
		}
		

		if ($start < 2 && !$cont)
		{
			$settings = unserialize($vbulletin->AME_settings);
			$start = 0;
			$limitstart = "0";
			build_datastore('AME_settings', serialize(array('in'=>$in, 'length' => $length, 'perpage' => $perpage, 'seconds' => $seconds, 'verbose' => $verbose, 'test' => $test, 'codes' => $settings['codes'], 'conversions' => $settings['conversions'])));
		}
		else
		{
			$limitstart = $start * $perpage;
		}

		$return 		= false;
		$x				= 0;

		require_once(DIR . "/includes/ame_bbcode.php");

		if ($deleteame)
		{
			//$and = " AND p.ame_flag = 1 ";
		}
		else if ($ignoreprevious)
		{
			//$and = " AND p.ame_flag = 0 ";
		}

		if ($length)
		{
			if ($in == 'vms')
			{
				$and .= " AND dateline >= $length ";
			}
			elseif ($in == 'blogs')
			{
				$and .= " AND dateline >= $length ";
			}
			elseif ($in == 'groups')
			{
				$and .= " AND dateline >= $length ";
			}
			else 
			{
				$and .= " AND p.dateline >= $length ";
			}
		}

		switch ($in)
		{
			case 'vms':
				$sql = "SELECT count(vmid) total FROM " . TABLE_PREFIX . "visitormessage WHERE 1=1  AND (pagetext LIKE '%[/url]%' OR pagetext LIKE '%[/ame]%') $and ";
				break;
			case 'blogs':
				$sql = "SELECT count(blogtextid) total FROM " . TABLE_PREFIX . "blog_text WHERE 1=1  AND (pagetext LIKE '%[/url]%' OR pagetext LIKE '%[/ame]%') $and ";
				break;
			case 'groups':
				$sql = "SELECT count(gmid) total FROM " . TABLE_PREFIX . "groupmessage WHERE 1=1  AND (pagetext LIKE '%[/url]%' OR pagetext LIKE '%[/ame]%') $and ";
				break;
			default:		
				$sql = "SELECT count(p.postid) total FROM " . TABLE_PREFIX . "post p WHERE 1=1  AND (p.pagetext LIKE '%[/url]%' OR p.pagetext LIKE '%[/ame]%') $and ";
		}
		
		$postcount = $db->query_first_slave($sql);

		if ($postcount['total'])
		{
			print_form_header('automediaembed_admin', 'dorebuildposts', false, true, 'statusform', '90%', '', true, 'get');
			print_table_header($vbphrase['automediaembed_rebuild_status']);
			print_description_row(construct_phrase($vbphrase['automediaembed_rebuild_status_x'], ceil($postcount['total'] / $perpage)));
			print_table_footer(); vbflush();

			switch ($in)
			{
				case 'vms':
					$sql = "SELECT vmid, pagetext, ame_flag  FROM " . TABLE_PREFIX . "visitormessage
						WHERE 1=1 AND (pagetext LIKE '%[/url]%' OR pagetext LIKE '%[/ame]%') $and ORDER BY dateline DESC LIMIT $limitstart, $perpage";					
					break;
				case 'blogs':
					$sql = "SELECT blogtextid, pagetext, ame_flag  FROM " . TABLE_PREFIX . "blog_text
						WHERE 1=1 AND (pagetext LIKE '%[/url]%' OR pagetext LIKE '%[/ame]%') $and ORDER BY dateline DESC LIMIT $limitstart, $perpage";					
					break;
				case 'groups':
					$sql = "SELECT gmid, pagetext, ame_flag  FROM " . TABLE_PREFIX . "groupmessage
						WHERE 1=1 AND (pagetext LIKE '%[/url]%' OR pagetext LIKE '%[/ame]%') $and ORDER BY dateline DESC LIMIT $limitstart, $perpage";					
					break;
				default:
					$sql = "SELECT p.postid, p.pagetext, p.ame_flag, t.forumid FROM " . TABLE_PREFIX . "post p INNER JOIN " . TABLE_PREFIX . "thread t on p.threadid = t.threadid
						WHERE 1=1 AND (p.pagetext LIKE '%[/url]%' OR p.pagetext LIKE '%[/ame]%') $and ORDER BY p.dateline DESC LIMIT $limitstart, $perpage";
			}
			
			$results = $db->query_read_slave($sql);

			define('AME_SKIP_PREM_CHECK', true);

			if ($db->num_rows($results))
			{
				echo("Building....<ul>");
				vbflush();

				while($result = $db->fetch_array($results))
				{
					$forumid = $result['forumid'];

					$x++;

					if ($x == $perpage)
					{
						$return = true;
					}
					
					switch ($in)
					{
						case 'vms':
							echo("<li>Visitor Message $result[vmid]: ");
							break;
						case 'blogs':
							echo("<li>Blog/Comment $result[blogtextid]: ");
							break;
						case 'groups':
							echo("<li>Group Message $result[gmid]: ");
							break;						
						default:
							echo("<li>post $result[postid]: ");
					}
					
					if (!$deleteame)
					{
						if ($ignoreprevious && !$result['ame_flag'])
						{
							if ($verbose)
							{
								$text = $result['pagetext'];
							}

							$returnvalue = ame_prep_text($result['pagetext']);
						}
						else
						{
							$returnvalue = 0;
						}
						if ($returnvalue)
						{

							if (!$test)
							{
								switch ($in)
								{
									case 'vms':
										$sql = "UPDATE " . TABLE_PREFIX . "visitormessage SET pagetext = '" . $db->escape_string($result['pagetext']) . "' ,ame_flag = $returnvalue WHERE vmid=$result[vmid]";
										$db->query_write($sql);
										break;
									case 'blogs':
										$sql = "UPDATE " . TABLE_PREFIX . "blog_text SET pagetext = '" . $db->escape_string($result['pagetext']) . "' ,ame_flag = $returnvalue WHERE blogtextid=$result[blogtextid]";
										$db->query_write($sql);
										$db->query_write("DELETE FROM " . TABLE_PREFIX . "blog_textparsed WHERE blogtextid=$result[blogtextid]");									
										break;
									case 'groups':
										$sql = "UPDATE " . TABLE_PREFIX . "groupmessage SET pagetext = '" . $db->escape_string($result['pagetext']) . "' ,ame_flag = $returnvalue WHERE gmid=$result[gmid]";
										$db->query_write($sql);
										break;										
									default:
										$sql = "UPDATE " . TABLE_PREFIX . "post SET pagetext = '" . $db->escape_string($result['pagetext']) . "' ,ame_flag = $returnvalue WHERE postid=$result[postid]";
										$db->query_write($sql);
										$db->query_write("DELETE FROM " . TABLE_PREFIX . "postparsed WHERE postid=$result[postid]");
								}
							}

							if ($verbose)
							{
								echo("<div style=\"border: medium;\">   was:<hr>" . htmlspecialchars_uni($text) . "<hr><br />it is now:<hr>" . htmlspecialchars_uni($result['pagetext']) . "<hr></div>");
							}
						}
						else
						{
							if (!$ignoreprevious && $result['ame_flag'])
							{
								switch ($in)
								{
									case 'vms':
										$db->query_write("UPDATE " . TABLE_PREFIX . "visitormessage SET ame_flag = 0  WHERE vmid=$result[vmid]");
										break;
									case 'blogs':
										$db->query_write("UPDATE " . TABLE_PREFIX . "blog_text SET ame_flag = 0  WHERE blogtextid=$result[blogtextid]");
										break;
									case 'groups':
										$db->query_write("UPDATE " . TABLE_PREFIX . "groupmessage SET ame_flag = 0  WHERE gmid=$result[gmid]");
										break;
									default:
										$db->query_write("UPDATE " . TABLE_PREFIX . "post SET ame_flag = 0  WHERE postid=$result[postid]");
								}
							}
							else if ($ignoreprevious && $result['ame_flag'])
							{
								echo("Ignored (already contains ame)");
							}
							else
							{
								echo("not changed");
							}
						}

					}
					else
					{
						$text = str_replace(array("[ame", "[/ame]"), array("[url", "[/url]"), $result['pagetext']);

						if (($text != $result['pagetext']) && $text)
						{
							echo("updated");
							if (!$test)
							{
								switch ($in)
								{
									case 'vms':
										$db->query_write("UPDATE " . TABLE_PREFIX . "visitormessage SET pagetext = '" . $db->escape_string($text) . "', ame_flag = 0  WHERE vmid=$result[vmid]");										
										break;
									case 'blogs':
										$db->query_write("UPDATE " . TABLE_PREFIX . "blog_text SET pagetext = '" . $db->escape_string($text) . "', ame_flag = 0  WHERE blogtextid=$result[blogtextid]");
										$db->query_write("DELETE FROM " . TABLE_PREFIX . "blog_textparsed WHERE blogtextid=$result[blogtextid]");										
										break;
									case 'groups':
										$db->query_write("UPDATE " . TABLE_PREFIX . "groupmessage SET pagetext = '" . $db->escape_string($text) . "', ame_flag = 0  WHERE gmid=$result[gmid]");										
										break;
									default:
										$db->query_write("UPDATE " . TABLE_PREFIX . "post SET pagetext = '" . $db->escape_string($text) . "', ame_flag = 0  WHERE postid=$result[postid]");
										$db->query_write("DELETE FROM " . TABLE_PREFIX . "postparsed WHERE postid=$result[postid]");
								}
							}

							if ($verbose)
							{
								echo("<div style=\"border: medium;\">   was:<hr>" . htmlspecialchars_uni($result['pagetext']) . "<hr><br />it is now:<hr>" . htmlspecialchars_uni($text) . "<hr></div>");
							}
						}
						else
						{
							switch ($in)
							{
								case 'vms':
									$db->query_write("UPDATE " . TABLE_PREFIX . "visitormessage SET ame_flag = 0  WHERE vmid=$result[vmid]");
									break;								
								case 'blogs':
									$db->query_write("UPDATE " . TABLE_PREFIX . "blog_text SET ame_flag = 0  WHERE blogtextid=$result[blogtextid]");
									break;
								case 'groups':
									$db->query_write("UPDATE " . TABLE_PREFIX . "groupmessage SET ame_flag = 0  WHERE gmid=$result[gmid]");
									break;
								default:
									$db->query_write("UPDATE " . TABLE_PREFIX . "post SET ame_flag = 0  WHERE postid=$result[postid]");
							}
							
							echo("not changed");
						}
					}

					echo("</li>");
					vbflush();
					unset($text);

					if ($return)
					{
						if (ceil($postcount['total'] / $perpage) == 1)
						{
							$return = false;
						}
					}
				}
				echo("</ul>");

			}
			else
			{
				switch ($in)
				{
					case 'vms':
						redirect('rebuildvms', 'automediaembed_no_results');
						break;						
					case 'blogs':
						redirect('rebuildblogs', 'automediaembed_no_results');
						break;
					case 'groups':
						redirect('rebuildgroups', 'automediaembed_no_results');
						break;
					default:
						redirect('rebuildposts', 'automediaembed_no_results');
				}

			}
		}
		else
		{
				switch ($in)
				{
					case 'vms':
						redirect('rebuildblogs', 'automediaembed_no_results');
						break;						
					case 'blogs':
						redirect('rebuildblogs', 'automediaembed_no_results');
						break;
					case 'groups':
						redirect('rebuildgroups', 'automediaembed_no_results');
						break;
					default:
						redirect('rebuildposts', 'automediaembed_no_results');
				}

		}

		print_form_header('automediaembed_admin', 'dorebuildposts', false, true, 'cpform', '90%', '', true, 'get');
		print_table_header($vbphrase['automediaembed_rebuild_title']);

		if ($return)
		{
			print_label_row($vbphrase['automediaembed_rebuild_seconds_till_next'], "<input type=\"text\" name=\"timer\" id=\"timer\" readonly=\"true\" value=\"$delay\" />");
			construct_hidden_code("cont", true);
			construct_hidden_code("ignoreprevious", $ignoreprevious);
			construct_hidden_code("deleteame", $deleteame);
			construct_hidden_code("perpage", $perpage);
			construct_hidden_code("seconds", $seconds);
			construct_hidden_code("length", $length);
			construct_hidden_code("test", $test);
			construct_hidden_code("verbose", $verbose);
			construct_hidden_code("start", $start+1);
			construct_hidden_code("in", $in);

			print_submit_row($vbphrase['next'], '');


			echo("<script language=\"javascript\"><!--

					var countdown = " . $seconds . ";

				  function submit_form()
				  {
				     document.cpform.submit();
				  }

				  function count_down()
				  {
				      countdown = countdown-1;
				  	  document.cpform.timer.value=countdown+ ' $vbphrase[automediaembed_rebuild_seconds_remaining]';
				  	  if (countdown == 0)
				  	  {
				  	  	submit_form();
				  	  }
				  	  else
				  	  {
				  	  	setTimeout('count_down()',1000);
				  	  }
				  }
				  //-->
				setTimeout('count_down()',1000);
			  </script>");

		}
		else
		{
			$inp = ($in ? $in . "_" : "");
			print_description_row($vbphrase['automediaembed_rebuild_' . $inp . 'completed']);
			print_table_footer();
		}


	}

	/**
	 * Convert posts
	 */
	if($action == 'convertposts')
	{

	    $lengths = array(
	    	0			=> $vbphrase['automediaembed_length_all'],
	    	604800		=> $vbphrase['automediaembed_length_one_week'],
	    	1209600		=> $vbphrase['automediaembed_length_two_weeks'],
	    	1814400		=> $vbphrase['automediaembed_length_three_weeks'],
	    	2419200		=> $vbphrase['automediaembed_length_one_month'],
	    	7862400		=> $vbphrase['automediaembed_length_three_months'],
	    	15724800	=> $vbphrase['automediaembed_length_six_months'],
	    	31449600	=> $vbphrase['automediaembed_length_one_year'],
	    );



	    if (!$settings)
	    {
	    	$settings = array(
	    		'length'	=> 	2419200,
	    		'perpage'	=>	100,
	    		'seconds'	=>	10,
	    	);

	    	if (!isset($settings['codes']))
	    	{
	    		$settings['codes'] 			= 'youtubevid, metacafe, ifilm, putfile, googlevid, myspacevid';
	    		$settings['conversions'] 	= 'http://www.youtube.com/watch?v=\1, http://www.metacafe.com/watch/\1, http://www.ifilm.com/video/\1, http://www.putfile\.com/\1, http://www.google.com/videoplay\?docid=\1, http://www.myspace.com/index.cfm?fuseaction=vids.individual&videoid=\1';
	    	}
	    }

		print_form_header('automediaembed_admin', 'doconversion', false, true, 'cpform', '90%', '', true, 'get');

		print_table_header($vbphrase['automediaembed_convert_warning_title']);
		print_description_row($vbphrase['automediaembed_convert_warning_desc']);
		print_checkbox_row($vbphrase['automediaembed_convert_warning'], 'ok', false);
		print_table_break();
		print_table_header($vbphrase['automediaembed_convert_title']);
		print_textarea_row($vbphrase['automediaembed_codes'], 'codes', $settings['codes']);
		print_textarea_row($vbphrase['automediaembed_conversions'], 'conversions', $settings['conversions']);
		print_yes_no_row($vbphrase['automediaembed_test_mode'], "test", true);
		print_yes_no_row($vbphrase['automediaembed_verbose_mode'], "verbose", false);
		print_select_row($vbphrase['automediaembed_length'], 'length', $lengths, $settings['length']);
		print_input_row($vbphrase['automediaembed_perpage'], 'perpage', $settings['perpage']);
		print_input_row($vbphrase['automediaembed_seconds_perpage'], 'seconds', $settings['seconds']);
		print_submit_row();

	}

	/**
	 * Do The Conversion (sounds like a dance!)
	 */
	if ($action == 'doconversion')
	{
		$vbulletin->input->clean_array_gpc('r', array(
			'length'				=> TYPE_UINT,
			'deleteame'				=> TYPE_BOOL,
			'perpage'				=> TYPE_UINT,
			'seconds'				=> TYPE_UINT,
			'cont'					=> TYPE_UINT,
			'conversions'			=> TYPE_STR,
			'codes'					=> TYPE_STR,
			'test'					=> TYPE_BOOL,
			'verbose'				=> TYPE_BOOL,
		));

		$length 			= $vbulletin->GPC['length'];
		$start				= $vbulletin->GPC['start'];
		$perpage 			= $vbulletin->GPC['perpage'];
		$seconds 			= $vbulletin->GPC['seconds'];
		$ignoreprevious		= $vbulletin->GPC['ignoreprevious'];
		$deleteame			= $vbulletin->GPC['deleteame'];
		$cont				= $vbulletin->GPC['cont'];
		$codes				= urldecode($vbulletin->GPC['codes']);
		$converts			= urldecode($vbulletin->GPC['conversions']);
		$test 				= $vbulletin->GPC['test'];
		$verbose 			= $vbulletin->GPC['verbose'];


		//safety checks
		$errors = array();

		build_datastore('AME_settings', serialize(array('length' => $length, 'perpage' => $perpage, 'seconds' => $seconds, 'codes' => $codes, 'conversions' => $converts)));

		$codes = explode(",", $codes);
		$converts = explode(",", $converts);

		if (!$_REQUEST['ok'])
		{
			$errors[] = $vbphrase['automediaembed_err_agree'];
		}

		if (!sizeof($codes))
		{
			$errors[] = $vbphrase['automediaembed_err_nocodes'];
		}

		if (sizeof($codes) != sizeof($converts))
		{
			$errors[] = $vbphrase['automediaembed_err_miscount'];
		}

		foreach($converts as $key => $value)
		{
			if (!trim($value))
			{
				$errors[] = $vbphrase['automediaembed_err_empty_conv'];
			}
			else
			{
				$value = trim($value);

				if (strpos($value, '\1') === false)
				{
					$errors[] = $vbphrase['automediaembed_err_missing_param'];
				}
				else
				{
					$replacements[] = "[url]$value" . "[/url]";
				}
			}
		}

		foreach($codes as $key => $value)
		{
			if (!trim($value))
			{
				$errors[] = $vbphrase['automediaembed_err_empty_code'];
			}
			else
			{
				$value = trim($value);
				$codelist .= ($codelist ? " OR " : "") . "p.pagetext LIKE '%[/" . $db->escape_string($value) . "]%'";
				$finds[] = "%\[$value\](.*?)\[/$value\]%sim";
			}
		}

		if (!$codelist)
		{
			$errors[] = $vbphrase['automediaembed_no_codelist'];
		}

		if (sizeof($errors))
		{
			foreach($errors as $value)
			{
				$errlist .= "<li>$value</li>";
			}
			print_form_header('automediaembed_admin', 'convertposts', 0, 1, '', '75%');
			print_table_header($vbphrase['automediaembed_err_title']);
			print_description_row(construct_phrase($vbphrase['automediaembed_err_message'], $errlist));
			print_table_footer(2, construct_button_code($vbphrase['go_back'], 'automediaembed_admin.php?do=convertposts'));
			print_cp_footer();
			exit;
		}

		$return 		= false;
		$x				= 0;

		if ($length)
		{
			$and .= " AND p.dateline >= $length ";
		}

		$sql = "SELECT count(p.postid) total FROM " . TABLE_PREFIX . "post p WHERE $codelist ";
		$postcount = $db->query_first_slave($sql);

		if ($postcount['total'])
		{
			print_form_header('automediaembed_admin', 'doconversion', false, true, 'statusform', '90%', '', true, 'get');
			print_table_header($vbphrase['automediaembed_conversion_status']);
			print_description_row(construct_phrase($vbphrase['automediaembed_rebuild_status_x'], ceil($postcount['total'] / $perpage)));
			print_table_footer(); vbflush();

			$sql = "SELECT p.postid, p.pagetext FROM " . TABLE_PREFIX . "post p
					WHERE $codelist ORDER BY p.dateline DESC LIMIT 0, $perpage";

			$results = $db->query_read_slave($sql);

			if ($db->num_rows($results))
			{
				echo("Converting....<ul>"); vbflush();
				while($result = $db->fetch_array($results))
				{
					$x++;
					if ($x == $perpage)
					{
						$return = true;
					}

					echo("<li>post $result[postid]: ");

					$text = preg_replace($finds, $replacements, $result['pagetext']);

					if ($text != $result['pagetext'])
					{
						if ($text)
						{
							if (!$test)
							{
								$db->query_write("UPDATE " . TABLE_PREFIX . "post SET pagetext = '" . $db->escape_string($text) . "' WHERE postid=$result[postid]");
								$db->query_write("DELETE FROM " . TABLE_PREFIX . "postparsed WHERE postid=$result[postid]");
								echo(" updated");
							}

							if ($verbose)
							{
									echo("<div style=\"border: medium;\">   was:<hr>" . htmlspecialchars_uni($result['pagetext']) . "<hr><br />it is now:<hr>" . htmlspecialchars_uni($text) . "<hr></div>");
							}

						}
						else
						{
							die("ERROR! Empty text returned. This means that you would have wiped out the entire message. Check your settings!!! Operation aborted.");
						}
					}
					else
					{
						echo("huh... no changes?");
					}

					echo("</li>"); vbflush();
					unset($text);

					if ($return)
					{
						if (ceil($postcount['total'] / $perpage) == 1)
						{
							$return = false;
						}
					}
				}
				echo("</ul>");
			}
			else
			{

				redirect('convertposts', 'automediaembed_no_results');
			}
		}
		else
		{
			redirect('convertposts', 'automediaembed_no_results');
		}

		print_form_header('automediaembed_admin', 'doconversion', false, true, 'cpform', '90%', '', true, 'get');
		print_table_header($vbphrase['automediaembed_convert_title']);

		if ($return)
		{
			print_label_row($vbphrase['automediaembed_rebuild_seconds_till_next'], "<input type=\"text\" name=\"timer\" id=\"timer\" readonly=\"true\" value=\"$delay\" />");
			construct_hidden_code("codes", implode(",", $codes));
			construct_hidden_code("conversions", implode(",", $converts));
			construct_hidden_code("ok", true);
			construct_hidden_code("cont", true);
			construct_hidden_code("perpage", $perpage);
			construct_hidden_code("seconds", $seconds);
			construct_hidden_code("length", $length);
			construct_hidden_code("do", "doconversion");
			construct_hidden_code("test", $test);
			construct_hidden_code("verbose", $verbose);
			print_table_footer(2, construct_button_code($vbphrase['next']));

			echo("<script language=\"javascript\"><!--

					var countdown = " . $seconds . ";

				  function submit_form()
				  {
				     document.cpform.submit();
				  }

				  function count_down()
				  {
				      countdown = countdown-1;
				  	  document.cpform.timer.value=countdown+ ' $vbphrase[automediaembed_rebuild_seconds_remaining]';
				  	  if (countdown == 0)
				  	  {
				  	  	submit_form();
				  	  }
				  	  else
				  	  {
				  	  	setTimeout('count_down()',1000);
				  	  }
				  }
				  //-->
				setTimeout('count_down()',1000);
			  </script>");

		}
		else
		{
			print_description_row($vbphrase['automediaembed_convert_completed']);
			print_table_footer();
		}


	}

	/**
	 * Display Items for exporting
	 */
	if($action == "export")
	{
		$results = $db->query_read_slave("SELECT id, title, description from " . TABLE_PREFIX . "automediaembed ORDER BY displayorder, title ASC");

		print_form_header('automediaembed_admin', 'doexport');

		if ($db->num_rows($results))
		{
			print_table_header($vbphrase['automediaembed_media_definitions'], 2);
			print_cells_row(array($vbphrase['title'], "<label for=\"export_toggle\">$vbphrase[export]</label> <input type=\"checkbox\" id=\"export_toggle\" onclick=\"tick_all(this.form, 'items', this.checked)\" />"), true);
			while($result = $db->fetch_array($results))
			{
				print_checkbox_row("$result[title]<dfn>$result[description]</dfn>", "items[$result[id]]");
			}

			print_submit_row();
		}
		else
		{
			print_table_header($vbphrase['automediaembed_media_definitions'], 2);
			print_description_row($vbphrase['automediaembed_no_definitions']);
			print_table_footer(2, construct_button_code("Add new", "automediaembed_admin.php?do=edit"));
		}
	}

	/**
	 * Do the export
	 */
	if($action == "doexport")
	{

		$items = $vbulletin->input->clean_gpc('p', 'items', TYPE_ARRAY_UINT);

		if (sizeof($items))
		{
			foreach ($items as $key => $value)
			{
				if ($value)
				{
					$ids .= ($ids ? "," : "") . $key;
				}
			}
			$results = $db->query_read_slave("SELECT * FROM " . TABLE_PREFIX . "automediaembed WHERE id IN ($ids)");
			while($result = $db->fetch_array($results))
			{
				$data["$result[id]"] = $result;
			}

		}
		else
		{
			die("No items in doexport!");
		}

		if (sizeof($data))
		{
		    require_once(DIR . '/includes/class_xml.php');
			$xml = new vB_XML_Builder($vbulletin);

			$xml->add_group("AME");

		    foreach($data as $key => $value)
		    {
				$xml->add_group("item");
				foreach($value as $columnname => $columnvalue)
				{
					$xml->add_tag($columnname, $columnvalue);
				}
				$xml->close_group();
		    }

		    $xml->close_group();

		    // ############## Finish up
		    $doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n" . $xml->output();

		    //echo("<pre>" . htmlspecialchars($doc) . "</pre>");exit;
		    unset($xml);

		    require_once(DIR . '/includes/functions_file.php');
		    file_download($doc, "AME.xml", 'text/xml');
		    exit;
		}
		else
		{
			die("Data export size is empty!");
		}

	}

	/**
	 * Show options for importing
	 */
	if ($action == "import")
	{
	?>

	        <script type="text/javascript">
	        <!--
	        function js_confirm_upload(tform, filefield)
	        {
	                if (filefield.value == "")
	                {
	                        return confirm("<?php echo construct_phrase($vbphrase['you_did_not_specify_a_file_to_upload'], '" + tform.serverfile.value + "'); ?>");
	                }
	                return true;
	        }
	        //-->
	        </script>

	<?php

	        print_form_header('automediaembed_admin', 'importoptions', 1, 1, 'uploadform" onsubmit="return js_confirm_upload(this, this.uploadedfile);');
	        print_table_header($vbphrase['import']);
	        print_description_row($vbphrase['automediaembed_import_desc']);
	        print_upload_row($vbphrase['upload_xml_file'], 'uploadedfile', 999999999);
	        print_input_row($vbphrase['import_xml_file'], 'serverfile', './includes/xml/ame.xml');
	        print_submit_row($vbphrase['import'], 0);
	}

	/**
	 * Display imported results
	 */
	if ($action == "importoptions")
	{

		$vbulletin->input->clean_gpc('f', 'uploadedfile', TYPE_FILE);
		$vbulletin->input->clean_gpc('p', 'serverfile', TYPE_FILE);

		print_dots_start($vbphrase['automediaembed_importing']);

		if (file_exists($vbulletin->GPC['uploadedfile']['tmp_name']))
		{
		        $xml = file_read($vbulletin->GPC['uploadedfile']['tmp_name']);
		}
		else if (file_exists($vbulletin->GPC['serverfile']))
		{
		        $xml = file_read($vbulletin->GPC['serverfile']);
		}
		else
		{
		        print_stop_message('no_file_uploaded_and_no_local_file_found');
		}

	    require_once(DIR . '/includes/class_xml.php');
		$xmlobj = new vB_XML_Parser($xml);

	    if ($xmlobj->error_no == 1)
	    {
			print_dots_stop();
			print_stop_message('no_xml_and_no_path');
	    }

	    if(!$arr = $xmlobj->parse())
	    {
	            print_dots_stop();
	            print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
	    }

	    print_dots_stop();

	    $items 	= array();

	    if (is_array($arr))
	    {
			if (sizeof($arr['item']))
			{
				print_form_header('automediaembed_admin', 'doimport','false');
				//display items
		    	print_table_header("Items");
		    	print_description_row("This is the content of the imported file. Select which ones to import and make any changes you want before clicking the import button.<p>Note that you can only create new entries this way!</p>");
		    	print_table_break();

		    	$x = 0;

                if (!isset($arr['item'][0]))
                {
                        $arr['item'] = array($arr['item']);
                }

		        foreach($arr['item'] as $data => $value)
		        {

	                    //foreach($entry as $key => $value)
	                    //{
	                    	print_table_header($value['title']);
	                    	print_checkbox_row($vbphrase['import'], "import[$x]");
							print_input_row($vbphrase['title'], "title[$x]", $value['title']);
							print_input_row($vbphrase['description'], "description[$x]", $value['description'], true, 35, 255);
							print_input_row($vbphrase['automediaembed_display_order'], "displayorder[$x]", $value['displayorder']);
							print_yes_no_row($vbphrase['automediaembed_active_desc'], "status[$x]", $value['status']);
							print_yes_no_row($vbphrase['automediaembed_contain_desc'], "container[$x]", $value['container']);
							print_textarea_row($vbphrase['automediaembed_search'], "findcode[$x]", $value['findcode']);
							print_textarea_row($vbphrase['automediaembed_replace'], "replacecode[$x]", $value['replacecode']);
							print_yes_no_row($vbphrase['automediaembed_extraction'], "extraction[$x]", $value['extraction']);
							print_textarea_row($vbphrase['automediaembed_embedregexp'], "embedregexp[$x]", $value['embedregexp']);
							$x++;
	                    //}

		        }

		        print_table_break();
			}
			else
			{
				print_stop_message('automediaembed_no_items_to_import');
			}
	    }
	    else
	    {
	    	print_stop_message('automediaembed_invalid_xml');
	    }

	    print_submit_row($vbphrase['import']);

	}

	/**
	 * Freaking well import them!
	 */
	if ($action == "doimport")
	{

		$vbulletin->input->clean_array_gpc('p', array(
			'import'		=> TYPE_ARRAY_BOOL,
			'title'			=> TYPE_ARRAY_STR,
			'description'	=> TYPE_ARRAY_STR,
			'displayorder'	=> TYPE_ARRAY_UINT,
			'findcode'		=> TYPE_ARRAY_STR,
			'replacecode'	=> TYPE_ARRAY_STR,
			'status'		=> TYPE_ARRAY_BOOL,
			'container'		=> TYPE_ARRAY_BOOL,
			'embedregexp'	=> TYPE_ARRAY_STR,
			'extraction'	=> TYPE_ARRAY_BOOL,
		));

		$import			= $vbulletin->GPC['import'];
		$title 			= $vbulletin->GPC['title'];
		$description 	= $vbulletin->GPC['description'];
		$displayorder 	= $vbulletin->GPC['displayorder'];
		$findcode 		= $vbulletin->GPC['findcode'];
		$replacecode	= $vbulletin->GPC['replacecode'];
		$status			= $vbulletin->GPC['status'];
		$container		= $vbulletin->GPC['container'];
		$embedregexp	= $vbulletin->GPC['embedregexp'];
		$extraction 	= $vbulletin->GPC['extraction'];

		foreach ($title as $key => $value)
		{
			if ($import["$key"])
			{
				$sql = "INSERT INTO " . TABLE_PREFIX . "automediaembed (title, description, displayorder, findcode, replacecode, status, container, embedregexp, extraction) VALUES (
					'" . $db->escape_string($title["$key"]) . "',
					'" . $db->escape_string($description["$key"]) . "',
					'$displayorder[$key]',
					'" . $db->escape_string($findcode["$key"]) . "',
					'" . $db->escape_string($replacecode["$key"]) . "', '" . $status["$key"] . "', '" . $container["$key"] . "', '" . $db->escape_string($embedregexp["$key"]) . "', '" . intval($extraction["$key"]) . "')";

				$db->query_write($sql);
			}
		}

		redirect("display", "automediaembed_imported");
	}



	print_cp_footer();

?>